package com.atlassian.extras.decoder.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

/**
 *
 */
public final class DelegatingLicenseDecoder implements LicenseDecoder {
    private final List<LicenseDecoder> licenseDecoders;

    public DelegatingLicenseDecoder(List<LicenseDecoder> licenseDecoders) {
        this.licenseDecoders = Collections.unmodifiableList(new ArrayList<LicenseDecoder>(licenseDecoders));
    }

    public boolean canDecode(String licenseString) {
        for (LicenseDecoder decoder : licenseDecoders) {
            if (decoder.canDecode(licenseString)) {
                return true;
            }
        }
        return false;
    }

    public Properties decode(final String licenseString) {
        for (LicenseDecoder licenseDecoder : licenseDecoders) {
            if (licenseDecoder.canDecode(licenseString)) {
                return licenseDecoder.decode(licenseString);
            }
        }
        throw new LicenseDecoderNotFoundException(licenseString, licenseDecoders);
    }
}
