/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.core.jira;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;
import com.atlassian.extras.core.jira.DefaultJiraLicense;
import com.atlassian.extras.core.transformer.DelegatingLicensePropertiesTransformer;
import com.atlassian.extras.core.transformer.LicenseEditionPropertyTransformer;
import com.atlassian.extras.core.transformer.LicensePropertiesTransformer;
import com.atlassian.extras.core.transformer.Version1LicenseTypeTransformer;
import java.util.Arrays;

public class JiraProductLicenseFactory
extends AbstractProductLicenseFactory {
    private final LicensePropertiesTransformer transformer = new DelegatingLicensePropertiesTransformer(Arrays.asList(new Version1LicenseTypeTransformer(), new LicenseEditionPropertyTransformer()));

    @Override
    protected LicensePropertiesTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.JIRA.equals((Object)product)) {
            return new DefaultJiraLicense(product, licenseProperties);
        }
        throw new LicenseException("Could not create Bamboo license for " + product);
    }
}

