package com.atlassian.extras.core.transformer;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.common.LicensePropertiesConstants;
import com.atlassian.extras.common.log.Logger;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.legacy.util.OldLicenseTypeResolver;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicenseTypeStore;

import java.util.Properties;

/**
 * Version 1 and an early edition of Version 2 carried the old license type name which described
 * license type, edition and whether it is an evaluation license or not.
 * Here we infer the right license type from the old name.
 */
public class Version1LicenseTypeTransformer implements LicensePropertiesTransformer {
    protected final Logger.Log log = Logger.getInstance(this.getClass());

    public LicenseProperties transform(Product product, LicenseProperties properties) {
        String licenseTypeName = properties.getProperty(LicensePropertiesConstants.LICENSE_TYPE_NAME);
        if (licenseTypeName == null) {
            String oldLicenseTypeName = properties.getProperty(LicensePropertiesConstants.LICENSE_TYPE);
            if (oldLicenseTypeName != null) {
                LicenseTypeStore typeStore = OldLicenseTypeResolver.getLicenseTypeStore(product);
                if (typeStore != null) {
                    try {
                        com.atlassian.license.LicenseType oldType = typeStore.getLicenseType(oldLicenseTypeName);
                        if (oldType != null) {
                            Properties prop = new Properties();
                            prop.setProperty(LicensePropertiesConstants.LICENSE_TYPE_NAME, oldType.getNewLicenseTypeName());

                            return new OverriddingLicenseProperties(product, properties, prop);
                        }
                    } catch (LicenseException e) {
                        log.warn("License type '" + oldLicenseTypeName + "' can not be resolved. This is a potentially corrupt license.", e);
                        return properties;
                    }
                }
            }
            log.warn("License type '" + oldLicenseTypeName + "' can not be resolved. This is a potentially corrupt license.");
            return properties;
        } else {
            // nothing to do
            return properties;
        }
    }
}