package com.atlassian.extras.core.transformer;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.common.util.ProductLicenseProperties;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * The class that wraps a ProductConfiguration and allows to have modifications overlaid without changing the original content.
 */
public class OverriddingLicenseProperties extends ProductLicenseProperties {
    private final LicenseProperties originalProperties;

    public OverriddingLicenseProperties(Product product, LicenseProperties config, Properties modifications) {
        super(product, modifications);
        this.originalProperties = config;
    }

    public String getProperty(String propertyName, String defaultValue) {
        // we pass null here because we don't want a default value, 
        // we just want to check if the value exists in the overriding set or not
        String value = super.getProperty(propertyName, null);
        if (value == null) {
            return originalProperties.getProperty(propertyName, defaultValue);
        } else {
            return value;
        }
    }

    public Map<String, String> getPropertiesEndingWith(final String ending) {
        Map<String, String> props = new HashMap<String, String>();
        props.putAll(originalProperties.getPropertiesEndingWith(ending));
        props.putAll(super.getPropertiesEndingWith(ending));
        return props;
    }
}
