package com.atlassian.extras.core.transformer;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.common.util.LicenseProperties;

import java.util.ArrayList;
import java.util.List;

public class DelegatingLicensePropertiesTransformer implements LicensePropertiesTransformer {
    private final List<LicensePropertiesTransformer> delegates;

    public DelegatingLicensePropertiesTransformer(List<LicensePropertiesTransformer> delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("delegates can not be null");
        }
        this.delegates = new ArrayList<LicensePropertiesTransformer>(delegates);
    }

    public LicenseProperties transform(Product product, LicenseProperties licenseProperties) {
        for (LicensePropertiesTransformer transformer : delegates) {
            licenseProperties = transformer.transform(product, licenseProperties);
        }
        return licenseProperties;
    }
}
