package com.atlassian.extras.core.stash;

import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;

/**
 * Implementation of {@link AbstractProductLicenseFactory} for generating new {@link StashLicense}s.
 */
public class StashProductLicenseFactory extends AbstractProductLicenseFactory {

    @Override
    protected StashLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.STASH.equals(product)) {
            return new DefaultStashLicense(product, licenseProperties);
        }
        throw new LicenseException("Could not create license for " + product);
    }
}
