package com.atlassian.extras.core.greenhopper;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;

/**
 * GreenHopper license factory
 *
 * @since 2.2.0
 */
public class GreenHopperProductLicenseFactory extends AbstractProductLicenseFactory {
    public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.GREENHOPPER.equals(product)) {
            return new DefaultGreenHopperLicense(product, licenseProperties);
        } else {
            throw new LicenseException("Could not create license for " + product);
        }
    }
}