package com.atlassian.extras.core.greenhopper;

import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.greenhopper.GreenHopperLicense;
import com.atlassian.extras.common.LicensePropertiesConstants;
import com.atlassian.extras.common.LicenseTypeAndEditionResolver;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.plugins.DefaultPluginLicense;

/**
 * The license implementation for the green hopper plugin.
 *
 * @since 2.2.0
 */
class DefaultGreenHopperLicense extends DefaultPluginLicense implements GreenHopperLicense {
    private final LicenseEdition licenseEdition;

    DefaultGreenHopperLicense(final Product product, LicenseProperties licenseProperties) {
        super(product, licenseProperties);

        String editionProperty = licenseProperties.getProperty(LicensePropertiesConstants.LICENSE_EDITION);
        this.licenseEdition = LicenseTypeAndEditionResolver.getLicenseEdition(editionProperty);
    }

    public LicenseEdition getLicenseEdition() {
        return licenseEdition;
    }
}