package com.atlassian.extras.core.fisheye;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;

public class FisheyeProductLicenseFactory extends AbstractProductLicenseFactory {
    public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.FISHEYE.equals(product)) {
            return new DefaultFisheyeLicense(product, licenseProperties);
        } else {
            throw new LicenseException("Could not create license for " + product);
        }
    }
}
