package com.atlassian.extras.core.crowd;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;
import com.atlassian.extras.core.ProductLicenseFactory;

/**
 * A {@link ProductLicenseFactory} for Crowd's licenses
 */
public class CrowdProductLicenseFactory extends AbstractProductLicenseFactory {
    public ProductLicense getLicenseInternal(final Product product, final LicenseProperties licenseProperties) {
        if (Product.CROWD.equals(product)) {
            return new DefaultCrowdLicense(product, licenseProperties);
        } else {
            throw new LicenseException("Could not create license for " + product);
        }
    }
}
