package com.atlassian.extras.core.confluence;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.extras.common.LicensePropertiesConstants;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.DefaultProductLicense;

class DefaultConfluenceLicense extends DefaultProductLicense implements ConfluenceLicense {
    private final int maximumNumberClusterNodes;

    DefaultConfluenceLicense(final Product product, LicenseProperties licenseProperties) {
        super(product, licenseProperties);
        final int maxClustNodes = licenseProperties.getInt(LicensePropertiesConstants.MAX_NUMBER_CONF_CLUSTER_NODES, LicensePropertiesConstants.DEFAULT_CONF_CLUSTER_NODES);
        this.maximumNumberClusterNodes = maxClustNodes != LicensePropertiesConstants.UNLIMITED_CONF_CLUSTER_NODES ? maxClustNodes : Integer.MAX_VALUE;
    }

    public int getMaximumNumberOfClusterNodes() {
        return maximumNumberClusterNodes;
    }
}