package com.atlassian.extras.core.confluence;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;
import com.atlassian.extras.core.ProductLicenseFactory;

/**
 * A {@link ProductLicenseFactory} for Confluence's licenses
 */
public class ConfluenceProductLicenseFactory extends AbstractProductLicenseFactory {
    public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.CONFLUENCE.equals(product)) {
            return new DefaultConfluenceLicense(product, licenseProperties);
        } else {
            throw new LicenseException("Could not create license for " + product);
        }
    }
}
