package com.atlassian.extras.core.bitbucket;

import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;

/**
 * Implementation of {@link AbstractProductLicenseFactory} for generating new {@link BitbucketServerLicense}s.
 */
public class BitbucketServerProductLicenseFactory extends AbstractProductLicenseFactory {

    @Override
    protected BitbucketServerLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.BITBUCKET_SERVER.equals(product)) {
            return new DefaultBitbucketServerLicense(product, licenseProperties);
        }
        throw new LicenseException("Could not create license for " + product);
    }
}
