package com.atlassian.extras.core.bamboo;

import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.extras.common.LicensePropertiesConstants;
import com.atlassian.extras.common.LicenseTypeAndEditionResolver;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.DefaultProductLicense;

import static com.atlassian.extras.core.bamboo.BambooLicenseAttributes.extractValue;

class DefaultBambooLicense extends DefaultProductLicense implements BambooLicense {
    private final int maximumNumberOfRemoteAgents;
    private final int maximumNumberOfLocalAgents;
    private final int maximumNumberOfPlans;
    private final LicenseEdition licenseEdition;

    DefaultBambooLicense(final Product product, LicenseProperties licenseProperties) {
        super(product, licenseProperties);
        this.licenseEdition = LicenseTypeAndEditionResolver.getLicenseEdition(licenseProperties.getProperty(LicensePropertiesConstants.LICENSE_EDITION));

        //check for the existence of specific bamboo properties. if unspecified, calculate them.
        Integer value;
        value = extractValue(licenseProperties, LicensePropertiesConstants.MAX_NUMBER_BAM_REMOTE_AGENTS);
        this.maximumNumberOfRemoteAgents = (value == null) ?
                BambooLicenseAttributes.calculateRemoteAgents(getLicenseType(), licenseEdition) : value;

        value = extractValue(licenseProperties, LicensePropertiesConstants.MAX_NUMBER_BAM_LOCAL_AGENTS);
        this.maximumNumberOfLocalAgents = (value == null) ?
                BambooLicenseAttributes.calculateLocalAgents(getLicenseType(), licenseEdition) : value;

        value = extractValue(licenseProperties, LicensePropertiesConstants.MAX_NUMBER_BAM_PLANS);
        this.maximumNumberOfPlans = (value == null) ? BambooLicenseAttributes.calculatePlans(getLicenseType()) : value;
    }

    public LicenseEdition getLicenseEdition() {
        return licenseEdition;
    }

    public int getMaximumNumberOfRemoteAgents() {
        return maximumNumberOfRemoteAgents;
    }

    public int getMaximumNumberOfLocalAgents() {
        return maximumNumberOfLocalAgents;
    }

    public int getMaximumNumberOfPlans() {
        return maximumNumberOfPlans;
    }

    public boolean isUnlimitedRemoteAgents() {
        return LicensePropertiesConstants.BAMBOO_UNLIMITED == maximumNumberOfRemoteAgents;
    }

    public boolean isUnlimitedLocalAgents() {
        return LicensePropertiesConstants.BAMBOO_UNLIMITED == maximumNumberOfLocalAgents;
    }

    public boolean isUnlimitedPlans() {
        return LicensePropertiesConstants.BAMBOO_UNLIMITED == maximumNumberOfPlans;
    }
}
