package com.atlassian.extras.core.bamboo;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AbstractProductLicenseFactory;
import com.atlassian.extras.core.ProductLicenseFactory;
import com.atlassian.extras.core.transformer.DelegatingLicensePropertiesTransformer;
import com.atlassian.extras.core.transformer.LicenseEditionPropertyTransformer;
import com.atlassian.extras.core.transformer.LicensePropertiesTransformer;
import com.atlassian.extras.core.transformer.Version1LicenseTypeTransformer;

import java.util.Arrays;

/**
 * A {@link ProductLicenseFactory} for Bamboo's licenses
 */
public class BambooProductLicenseFactory extends AbstractProductLicenseFactory {
    private final LicensePropertiesTransformer transformer = new DelegatingLicensePropertiesTransformer(
            Arrays.asList(new Version1LicenseTypeTransformer(), new LicenseEditionPropertyTransformer()));

    protected LicensePropertiesTransformer getTransformer() {
        return transformer;
    }

    public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.BAMBOO.equals(product)) {
            return new DefaultBambooLicense(product, licenseProperties);
        } else {
            throw new LicenseException("Could not create license for " + product);
        }
    }
}
