package com.atlassian.extras.core.bamboo;

import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.common.util.LicenseProperties;

/**
 * Utility class for Bamboo license attributes.
 */
public abstract class BambooLicenseAttributes {
    public static final int MAX_REMOTE_AGENTS_NONE = 0;
    public static final int MAX_REMOTE_AGENTS_STANDARD = 1;
    public static final int MAX_REMOTE_AGENTS_PROFESSIONAL = 10;
    public static final int MAX_REMOTE_AGENTS_ENTERPRISE = 25;
    public static final int MAX_REMOTE_AGENTS_UNLIMITED = 100;

    public static final int MAX_LOCAL_AGENTS_BASIC = 1;
    public static final int MAX_LOCAL_AGENTS_UNLIMITED = -1;

    public static final int MAX_PLANS_STARTER = 10;
    public static final int MAX_PLANS_UNLIMITED = -1;

    public static int calculateRemoteAgents(LicenseType licenseType, LicenseEdition licenseEdition) {
        if (LicenseType.STARTER.equals(licenseType)) {
            return MAX_REMOTE_AGENTS_NONE;
        } else if (LicenseEdition.STANDARD.equals(licenseEdition)) {
            return MAX_REMOTE_AGENTS_STANDARD;
        } else if (LicenseEdition.PROFESSIONAL.equals(licenseEdition)) {
            return MAX_REMOTE_AGENTS_PROFESSIONAL;
        } else if (LicenseEdition.ENTERPRISE.equals(licenseEdition)) {
            return MAX_REMOTE_AGENTS_ENTERPRISE;
        } else if (LicenseEdition.UNLIMITED.equals(licenseEdition)) {
            return MAX_REMOTE_AGENTS_UNLIMITED;
        } else {
            return MAX_REMOTE_AGENTS_NONE;
        }
    }

    public static int calculateLocalAgents(LicenseType licenseType, LicenseEdition licenseEdition) {
        if (LicenseType.STARTER.equals(licenseType)) {
            return MAX_LOCAL_AGENTS_UNLIMITED;
        } else if (LicenseEdition.BASIC.equals(licenseEdition)) {
            return MAX_LOCAL_AGENTS_BASIC;
        } else {
            return MAX_LOCAL_AGENTS_UNLIMITED;
        }
    }

    public static int calculatePlans(LicenseType licenseType) {
        if (LicenseType.STARTER.equals(licenseType)) {
            return MAX_PLANS_STARTER;
        } else {
            return MAX_PLANS_UNLIMITED;
        }
    }

    public static Integer extractValue(LicenseProperties licenseProperties, String param) {
        String value = licenseProperties.getProperty(param);
        if (value != null && value.length() != 0) {
            try {
                return Integer.parseInt(value);
            } catch (NumberFormatException e) {
                // default to checking edition
            }
        }

        return null;
    }
}
