package com.atlassian.extras.core;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.util.LicenseProperties;

/**
 *
 */
public interface ProductLicenseFactory {
    /**
     * Tells whether the given configuration includes a license for the given product.
     *
     * @param product           the product to find licensing information for.
     * @param licenseProperties the configuration
     * @return {@code true} if the configuration contains {@link Product product} license, {@code false}
     * otherwise.
     */
    boolean hasLicense(Product product, LicenseProperties licenseProperties);

    ProductLicense getLicense(Product product, LicenseProperties licenseProperties);
}
