package com.atlassian.extras.core;

import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.util.ProductLicenseProperties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class DefaultAtlassianLicenseFactory implements AtlassianLicenseFactory {
    private final Map<Product, ProductLicenseFactory> productLicenseFactoryMap;

    public DefaultAtlassianLicenseFactory(Map<Product, ProductLicenseFactory> productLicenseFactoryMap) {
        this.productLicenseFactoryMap = Collections.unmodifiableMap(new HashMap<Product, ProductLicenseFactory>(productLicenseFactoryMap));
    }

    public AtlassianLicense getLicense(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("licenceProperties must NOT be null!");
        }

        final Collection<ProductLicense> productLicenses = new ArrayList<ProductLicense>();
        for (Map.Entry<Product, ProductLicenseFactory> entry : productLicenseFactoryMap.entrySet()) {
            final Product product = entry.getKey();
            final ProductLicenseFactory licenseFactory = entry.getValue();
            final ProductLicenseProperties productLicenseProperties = new ProductLicenseProperties(product, properties);
            if (licenseFactory.hasLicense(product, productLicenseProperties)) {
                productLicenses.add(licenseFactory.getLicense(product, productLicenseProperties));
            }
        }

        return new DefaultAtlassianLicense(productLicenses);
    }
}
