package com.atlassian.extras.core;

import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.ProductLicense;

import java.util.Properties;

/**
 * A factory to create {@link AtlassianLicense Atlassian licenses} from a {@link Properties set of properties}.
 */
public interface AtlassianLicenseFactory {
    /**
     * @param licenseProperties the set of properties to convert to a {@link AtlassianLicense license}
     * @return an {@link AtlassianLicense} object, containing 0 or more {@link ProductLicense product license(s)}.
     * @throws IllegalArgumentException if licenseProperties is {@code null}
     */
    AtlassianLicense getLicense(Properties licenseProperties);
}
