package com.atlassian.extras.core;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.transformer.LicensePropertiesTransformer;
import com.atlassian.extras.core.transformer.Version1LicenseTypeTransformer;

import static com.atlassian.extras.common.LicensePropertiesConstants.ACTIVE_FLAG;
import static com.atlassian.extras.common.LicensePropertiesConstants.ACTIVE_VALUE;

/**
 *
 */
public abstract class AbstractProductLicenseFactory implements ProductLicenseFactory {
    // if we need more of these - introduce a delegating one
    private final LicensePropertiesTransformer transformer = new Version1LicenseTypeTransformer();

    public boolean hasLicense(final Product product, final LicenseProperties licenseProperties) {
        return ACTIVE_VALUE.equals(licenseProperties.getProperty(ACTIVE_FLAG));
    }

    public final ProductLicense getLicense(Product product, LicenseProperties licenseProperties) {
        return getLicenseInternal(product, getTransformer().transform(product, licenseProperties));
    }

    protected abstract ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties);

    protected LicensePropertiesTransformer getTransformer() {
        return transformer;
    }
}
