package com.atlassian.extras.common.log;

import java.io.PrintStream;


class StdErrLogger implements Logger.Log {


    private final Logger.Level level;

    StdErrLogger() {
        this(Logger.Level.INFO);
    }

    StdErrLogger(Logger.Level level) {
        this.level = level;
    }

    private static final PrintStream PRINT_STREAM = System.err;

    public void setClass(Class clazz) {
        // noop
    }

    public void debug(Object msg) {
        if (level.compareTo(Logger.Level.DEBUG) <= 0) {
            PRINT_STREAM.println(msg);
        }
    }

    public void debug(Object msg, Throwable t) {
        if (level.compareTo(Logger.Level.DEBUG) <= 0) {
            PRINT_STREAM.println(msg);
            t.printStackTrace(PRINT_STREAM);
        }
    }

    public void info(Object msg) {
        if (level.compareTo(Logger.Level.INFO) <= 0) {
            PRINT_STREAM.println(msg);
        }
    }

    public void info(Object msg, Throwable t) {
        if (level.compareTo(Logger.Level.INFO) <= 0) {
            PRINT_STREAM.println(msg);
            t.printStackTrace(PRINT_STREAM);
        }
    }

    public void warn(Object msg) {
        if (level.compareTo(Logger.Level.WARN) <= 0) {
            PRINT_STREAM.println(msg);
        }
    }

    public void warn(Object msg, Throwable t) {
        if (level.compareTo(Logger.Level.WARN) <= 0) {
            PRINT_STREAM.println(msg);
            t.printStackTrace(PRINT_STREAM);
        }
    }

    public void error(Object msg) {
        if (level.compareTo(Logger.Level.ERROR) <= 0) {
            PRINT_STREAM.println(msg);
        }
    }

    public void error(Object msg, Throwable t) {
        if (level.compareTo(Logger.Level.ERROR) <= 0) {
            PRINT_STREAM.println(msg);
            t.printStackTrace(PRINT_STREAM);
        }
    }

    public void error(Throwable t) {
        if (level.compareTo(Logger.Level.ERROR) <= 0) {
            t.printStackTrace(PRINT_STREAM);
        }
    }

    public void fatal(Object msg) {
        if (level.compareTo(Logger.Level.FATAL) <= 0) {
            PRINT_STREAM.println(msg);
        }
    }

    public void fatal(Object msg, Throwable t) {
        if (level.compareTo(Logger.Level.FATAL) <= 0) {
            PRINT_STREAM.println(msg);
            t.printStackTrace(PRINT_STREAM);
        }
    }

    public void fatal(Throwable t) {
        if (level.compareTo(Logger.Level.FATAL) <= 0) {
            t.printStackTrace(PRINT_STREAM);
        }
    }
}
