package com.atlassian.extras.common.log;


/**
 * This class exists to isolate the log4j dependency in the atlassian-extra module.
 * Needed because some products (Clover) can't have a log4j dependency.
 */
public class Logger {
    private static final Class<?> LOG4J_LOGGER_CLASS;

    static {
        Class log4jLogger = null;
        try {
            log4jLogger = Class.forName("com.atlassian.extras.common.log.Log4jLogger");
        } catch (ClassNotFoundException e) {
            // ignored
        } finally {
            LOG4J_LOGGER_CLASS = log4jLogger;
        }
    }

    public enum Level {
        DEBUG, INFO, WARN, ERROR, FATAL
    }

    public static interface Log {
        public void setClass(Class clazz);

        public void debug(Object o);

        public void debug(Object o, Throwable t);

        public void info(Object o);

        public void info(Object o, Throwable t);

        public void warn(Object o);

        public void warn(Object o, Throwable t);

        public void error(Object o);

        public void error(Object o, Throwable t);

        public void fatal(Object o);

        public void fatal(Object o, Throwable t);

    }

    private static Log logger;
    private static Level stdErrLogLevel = Level.INFO;

    public static void setInstance(Log logger) {
        Logger.logger = logger;
    }

    public static Log getInstance(Class clazz) {
        // if a logger instance has been set, use it.
        if (logger != null) {
            return logger;
        }

        // else try and get a Log4JLogger if possible
        try {
            if (LOG4J_LOGGER_CLASS != null) {
                final Log log4j = (Log) ((Class) LOG4J_LOGGER_CLASS).newInstance();
                log4j.setClass(clazz);
                return log4j;

            }
        } catch (IllegalAccessException e) {
            // ignore
        } catch (InstantiationException e) {
            // ignore
        } catch (NoClassDefFoundError e) {
            // ignore
        }

        // otherwise use std err
        logger = new StdErrLogger(stdErrLogLevel);
        return logger;
    }

    public static void setStdErrLogLevel(Level stdErrLogLevel) {
        if (stdErrLogLevel == null) {
            throw new IllegalArgumentException("StdErrLogger Log Level must not be null.");
        }
        Logger.stdErrLogLevel = stdErrLogLevel;
        Logger.logger = null;
    }
}


