package com.atlassian.extras.common;

import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.LicenseType;

/**
 * Utility to resolve license edition and type using their "name".
 * This will uppercase the name parameters before resolution and translate exceptions into {@link LicenseException}.
 */
public class LicenseTypeAndEditionResolver {
    public static LicenseEdition getLicenseEdition(String editionName) {
        try {
            return LicenseEdition.valueOf(editionName.toUpperCase());
        } catch (IllegalArgumentException e) {
            throw new LicenseException("Failed to lookup license edition <" + editionName + ">");
        } catch (NullPointerException e) {
            throw new LicenseException("Failed to lookup license edition <" + editionName + ">");
        }
    }

    public static LicenseType getLicenseType(String typeName) {
        try {
            return LicenseType.valueOf(typeName.toUpperCase());
        } catch (IllegalArgumentException e) {
            throw new LicenseException("Failed to lookup license type <" + typeName + ">");
        } catch (NullPointerException e) {
            throw new LicenseException("Failed to lookup license type <" + typeName + ">");
        }
    }
}
