package com.atlassian.extras.common;

import com.atlassian.extras.api.Product;

import java.util.Date;

/**
 * Set of constants and convenience methods used when dealing with license properties.
 */
public final class LicensePropertiesConstants {
    public static final String LICENSE_VERSION = "licenseVersion";

    /**
     * name of the property telling the license for a product exists, when "namespaced", e.g. confluence.active
     */
    public static final String ACTIVE_FLAG = "active";

    /**
     * value of the {@link #ACTIVE_FLAG} for the license to be created
     */
    public static final String ACTIVE_VALUE = "true";

    public static final String ORGANISATION = "Organisation";
    public static final String CONTACT_NAME = "ContactName";
    public static final String CONTACT_EMAIL = "ContactEMail";

    public static final String LICENSE_EXPIRY_DATE = "LicenseExpiryDate";
    public static final String GRACE_PERIOD = "GracePeriod";
    public static final int DEFAULT_GRACE_PERIOD = 0;
    public static final String MAINTENANCE_EXPIRY_DATE = "MaintenanceExpiryDate";
    public static final String PURCHASE_DATE = "PurchaseDate";
    public static final String CREATION_DATE = "CreationDate";
    public static final String SERVER_ID = "ServerID";
    public static final String LICENSE_ID = "LicenseID";

    /**
     * This is the license type as carried by the old/legacy license.
     * This include the type name, the edition and the evaluation information
     *
     * @see #LICENSE_TYPE_NAME
     */
    public static final String LICENSE_TYPE = "LicenseType";

    /**
     * This is the license type name as carried by the new license. This is just the license type name!
     *
     * @see #LICENSE_TYPE
     */
    public static final String LICENSE_TYPE_NAME = "LicenseTypeName";
    public static final String MAX_NUMBER_OF_USERS = "NumberOfUsers";
    public static final String PARTNER_NAME = "PartnerName";
    public static final String EVALUATION_LICENSE = "Evaluation";
    public static final String STARTER_LICENSE = "Starter";
    public static final String SUBSCRIPTION_LICENSE = "Subscription";
    public static final String DESCRIPTION = "Description";
    public static final String SUPPORT_ENTITLEMENT_NUMBER = "SEN";

    public static final String NAMESPACE_SEPARATOR = ".";

    /*
     * Defaults for various properties
     */
    public static final Date DEFAULT_CREATION_DATE = DateEditor.getDate("1970-01-01");
    public static final Date DEFAULT_EXPIRY_DATE = DEFAULT_CREATION_DATE;

    public static final int UNLIMITED_USERS = -1;
    public static final int DEFAULT_MAX_USERS = 0;

    /*
     * Confluence license property that specifies cluster node limit
     */
    public static final String MAX_NUMBER_CONF_CLUSTER_NODES = "NumberOfClusterNodes";
    public static final int UNLIMITED_CONF_CLUSTER_NODES = -1;
    public static final int DEFAULT_CONF_CLUSTER_NODES = 0;

    /*
     * Bamboo license property that specifies agent limit
     */
    public static final String MAX_NUMBER_BAM_REMOTE_AGENTS = "NumberOfBambooRemoteAgents";
    public static final String MAX_NUMBER_BAM_LOCAL_AGENTS = "NumberOfBambooLocalAgents";
    public static final String MAX_NUMBER_BAM_PLANS = "NumberOfBambooPlans";
    public static final int DEFAULT_BAM_REMOTE_AGENTS = 1;
    public static final int DEFAULT_BAM_LOCAL_AGENTS = -1;
    public static final int DEFAULT_BAM_PLANS = -1;
    public static final int BAMBOO_UNLIMITED = -1;

    /*
     * License property that specifies the license edition (Enterprise, Standard, Professional etc.)
     */
    public static final String LICENSE_EDITION = "LicenseEdition";

    /**
     * A license property suffix that shows if this license includes datacenter (e.g. clustering)
     */
    public static final String DATA_CENTER = "DataCenter";

    public static final String LICENSE_HASH_KEY_VERSION = "keyVersion";
    public static final String LICENSE_HASH = "licenseHash";

    /**
     * No instantiation of this class.
     */
    private LicensePropertiesConstants() {
    }

    /**
     * @return a property key with the given product's namespace.
     */
    public static String getKey(final Product product, final String key) {
        return product.getNamespace() + NAMESPACE_SEPARATOR + key;
    }
}
