package com.atlassian.extras.common;

import java.util.Date;

/**
 * Exception used when an error happens parsing dates
 * (either way, from {@link String} to {@link Date} or the other way round).
 */
/// CLOVER:OFF
public class DateParsingException extends LicenseException {
    private final String dateString;

    public DateParsingException(final String dateString) {
        this.dateString = dateString;
    }

    public DateParsingException(String dateString, Throwable throwable) {
        super(throwable);
        this.dateString = dateString;
    }

    public String getMessage() {
        return "Could NOT parse <" + dateString + "> into a 'license' date";
    }
}
