/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.common.test.rule;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EnvRule
implements TestRule {
    private final int maxCharsets;

    public EnvRule() {
        this(Integer.MAX_VALUE);
    }

    public EnvRule(int maxCharsets) {
        this.maxCharsets = maxCharsets;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String originalLineSeparator = System.lineSeparator();
                Charset originalCharset = Charset.defaultCharset();
                try {
                    for (String lineSeparator : Arrays.asList("\n", "\r\n")) {
                        EnvRule.this.setLineSeparator(lineSeparator);
                        for (Charset charset : EnvRule.this.charsets()) {
                            EnvRule.this.setDefaultEncoding(charset);
                            base.evaluate();
                        }
                    }
                }
                finally {
                    EnvRule.this.setLineSeparator(originalLineSeparator);
                    EnvRule.this.setDefaultEncoding(originalCharset);
                }
            }
        };
    }

    private Collection<Charset> charsets() {
        ArrayList<Charset> charsets = new ArrayList<Charset>(Charset.availableCharsets().values());
        Collections.shuffle(charsets);
        return charsets.subList(0, Math.min(this.maxCharsets, charsets.size()));
    }

    private void setDefaultEncoding(Charset charset) throws Exception {
        Field defaultCharset = Charset.class.getDeclaredField("defaultCharset");
        defaultCharset.setAccessible(true);
        defaultCharset.set(null, null);
        System.setProperty("file.encoding", charset.name());
    }

    private void setLineSeparator(String lineSeparator) throws Exception {
        System.setProperty("line.separator", lineSeparator);
        Field lineSeparatorField = System.class.getDeclaredField("lineSeparator");
        lineSeparatorField.setAccessible(true);
        lineSeparatorField.set(null, lineSeparator);
    }
}

