/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.EventPublisherUtils;
import com.atlassian.event.internal.InvokerTransformer;
import com.atlassian.event.internal.ListenerInvokerWithClassHierarchyAndRegisterOrder;
import com.atlassian.event.internal.ListenerInvokerWithRegisterOrder;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.scope.EverythingIsActiveScopeManager;
import com.atlassian.plugin.scope.ScopeManager;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockFreeEventPublisher
implements EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(LockFreeEventPublisher.class);
    private static final EverythingIsActiveScopeManager SCOPE_MANAGER = new EverythingIsActiveScopeManager();
    private final InvokerBuilder invokerBuilder;
    private final Publisher publisher;
    private final Listeners listeners = new Listeners();

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this(eventDispatcher, listenerHandlersConfiguration, (invokers, event) -> invokers);
    }

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration, InvokerTransformer transformer) {
        this.invokerBuilder = new InvokerBuilder(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.publisher = new Publisher(eventDispatcher, this.listeners, transformer);
    }

    @Override
    public void publish(@Nonnull Object event) {
        Preconditions.checkNotNull((Object)event);
        this.publisher.dispatch(event);
    }

    @Override
    public void register(@Nonnull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.unregister(listener);
        this.listeners.register(listener, this.invokerBuilder.build(listener));
    }

    @Override
    public void unregister(@Nonnull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    @Override
    public void unregisterAll() {
        this.listeners.clear();
    }

    static final class InvokerBuilder {
        private final Iterable<ListenerHandler> listenerHandlers;

        InvokerBuilder(@Nonnull Iterable<ListenerHandler> listenerHandlers) {
            this.listenerHandlers = (Iterable)Preconditions.checkNotNull(listenerHandlers);
        }

        Iterable<ListenerInvoker> build(Object listenerOrMd) throws IllegalArgumentException {
            Object listener = EventPublisherUtils.getListener(listenerOrMd);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                builder.addAll(listenerHandler.getInvokers(listener));
            }
            ImmutableList invokers = builder.build();
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
            }
            return invokers;
        }
    }

    static final class Publisher {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Listeners listeners;
        private final EventDispatcher dispatcher;
        private final InvokerTransformer transformer;

        Publisher(EventDispatcher dispatcher, Listeners listeners, InvokerTransformer transformer) {
            this.dispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)dispatcher);
            this.listeners = (Listeners)Preconditions.checkNotNull((Object)listeners);
            this.transformer = (InvokerTransformer)Preconditions.checkNotNull((Object)transformer);
        }

        void dispatch(Object event) {
            Iterable<ListenerInvoker> invokers = this.findListenerInvokersForEvent(event);
            try {
                invokers = this.transformer.transformAll(invokers, event);
            }
            catch (Exception e) {
                this.log.error("Exception while transforming invokers. Dispatching original invokers instead.", (Throwable)e);
            }
            boolean debugThisInvocation = EventPublisherUtils.shouldDebugThisInvocation(event);
            for (ListenerInvoker invoker : invokers) {
                if (debugThisInvocation) {
                    EventPublisherUtils.logInvocation(this.log, event, invoker);
                }
                try {
                    this.dispatcher.dispatch(invoker, event);
                }
                catch (Exception e) {
                    this.log.error("There was an exception thrown trying to dispatch event '{}' from the invoker '{}'.", new Object[]{event, invoker, e});
                }
            }
        }

        private Set<ListenerInvoker> findListenerInvokersForEvent(Object event) {
            Set<ListenerInvokerWithClassHierarchyAndRegisterOrder> invokers = EventPublisherUtils.getInvokersWithClassHierarchyOrder(event, this.listeners::get);
            return EventPublisherUtils.sortInvokers((ScopeManager)SCOPE_MANAGER, invokers);
        }
    }

    static final class Invokers {
        private final ConcurrentMap<Object, Collection<ListenerInvokerWithRegisterOrder>> listeners = new MapMaker().weakKeys().makeMap();

        Invokers() {
        }

        Collection<ListenerInvokerWithRegisterOrder> all() {
            return this.listeners.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        void remove(Object key) {
            this.listeners.remove(key);
        }

        void add(Object key, ListenerInvokerWithRegisterOrder invoker) {
            this.listeners.computeIfAbsent(key, k -> new ArrayList()).add(invoker);
        }
    }

    static final class Listeners {
        private final LoadingCache<Class<?>, Invokers> invokers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Invokers>(){

            public Invokers load(@Nonnull Class<?> key) {
                return new Invokers();
            }
        });

        Listeners() {
        }

        void register(Object listener, Iterable<ListenerInvoker> invokers) {
            for (ListenerInvoker invoker : invokers) {
                this.register(listener, invoker);
            }
        }

        private void register(Object listener, ListenerInvoker invoker) {
            Set<Class<Object>> supportedEventTypes = invoker.getSupportedEventTypes();
            if (supportedEventTypes.isEmpty()) {
                supportedEventTypes = Collections.singleton(Object.class);
            }
            for (Class<?> eventClass : supportedEventTypes) {
                EventPublisherUtils.logRegistration(log, eventClass, invoker);
                ((Invokers)this.invokers.getUnchecked(eventClass)).add(listener, new ListenerInvokerWithRegisterOrder(listener, invoker, Optional.empty()));
            }
        }

        void remove(Object listener) {
            this.invokers.asMap().forEach((k, listeners) -> listeners.remove(listener));
        }

        void clear() {
            this.invokers.invalidateAll();
        }

        public Collection<ListenerInvokerWithRegisterOrder> get(Class<?> eventClass) {
            return ((Invokers)this.invokers.getUnchecked(eventClass)).all();
        }
    }
}

