/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.internal.EventThreadFactory;
import com.atlassian.event.spi.EventExecutorFactory;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;

public class EventExecutorFactoryImpl
implements EventExecutorFactory {
    private final EventThreadPoolConfiguration configuration;
    private final EventThreadFactory eventThreadFactory;

    public EventExecutorFactoryImpl(EventThreadPoolConfiguration configuration, EventThreadFactory eventThreadFactory) {
        this.configuration = (EventThreadPoolConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.eventThreadFactory = (EventThreadFactory)Preconditions.checkNotNull((Object)eventThreadFactory);
    }

    public EventExecutorFactoryImpl(EventThreadPoolConfiguration configuration) {
        this(configuration, new EventThreadFactory());
    }

    public Executor getExecutor() {
        return new ThreadPoolExecutor(this.configuration.getCorePoolSize(), this.configuration.getMaximumPoolSize(), this.configuration.getKeepAliveTime(), this.configuration.getTimeUnit(), new SynchronousQueue<Runnable>(), this.eventThreadFactory);
    }
}

