package com.atlassian.event.internal;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.spi.EventExecutorFactory;

import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;

import static com.google.common.base.Preconditions.checkNotNull;

public class EventExecutorFactoryImpl implements EventExecutorFactory
{
    private final EventThreadPoolConfiguration configuration;

    public EventExecutorFactoryImpl(EventThreadPoolConfiguration configuration)
    {
        this.configuration = checkNotNull(configuration);
    }

    public Executor getExecutor()
    {
        return new ThreadPoolExecutor(
                configuration.getCorePoolSize(),
                configuration.getMaximumPoolSize(),
                configuration.getKeepAliveTime(),
                configuration.getTimeUnit(),
                new SynchronousQueue<Runnable>(),
                new EventThreadFactory());
    }
}
