/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.internal.AnnotationAsynchronousEventResolver;
import com.atlassian.event.internal.AsynchronousEventResolver;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;

public final class AsynchronousAbleEventDispatcher
implements EventDispatcher {
    private static final Executor SYNCHRONOUS_EXECUTOR = new Executor(){

        public void execute(Runnable command) {
            command.run();
        }
    };
    private final Executor asynchronousExecutor;
    private final AsynchronousEventResolver asynchronousEventResolver;

    public AsynchronousAbleEventDispatcher(Executor asynchronousExecutor) {
        this(asynchronousExecutor, new AnnotationAsynchronousEventResolver());
    }

    AsynchronousAbleEventDispatcher(Executor asynchronousExecutor, AsynchronousEventResolver asynchronousEventResolver) {
        this.asynchronousEventResolver = (AsynchronousEventResolver)Preconditions.checkNotNull((Object)asynchronousEventResolver);
        this.asynchronousExecutor = (Executor)Preconditions.checkNotNull((Object)asynchronousExecutor);
    }

    public void dispatch(final ListenerInvoker invoker, final Object event) {
        this.getExecutor((ListenerInvoker)Preconditions.checkNotNull((Object)invoker), Preconditions.checkNotNull((Object)event)).execute(new Runnable(){

            public void run() {
                invoker.invoke(event);
            }
        });
    }

    private Executor getExecutor(ListenerInvoker invoker, Object event) {
        return this.asynchronousEventResolver.isAsynchronousEvent(event) && invoker.supportAsynchronousEvents() ? this.asynchronousExecutor : SYNCHRONOUS_EXECUTOR;
    }
}

