package com.atlassian.event.api;

/**
 * Interface to publish events. It essentially allows to register event listeners and dispatch events.
 * @since 2.0
 */
public interface EventPublisher
{
    /**
     * Publish an event that will be consumed by all listeners which have registered to receive it.
     * @param event the event to publish
     * @throws NullPointerException if the event is {@code null}
     */
    void publish(Object event);

    /**
     * Register a listener to receive events.
     * @param listener The listener that is being registered
     * @throws NullPointerException if the listener is {@code null}
     * @throws IllegalArgumentException if the parameter is not found to be an actual listener
     */
    void register(Object listener);

    /**
     * Un-register a listener so that it will no longer receive events. If the given listener is not registered nothing
     * will happen.
     * @param listener The listener to un-register
     * @throws NullPointerException if the listener is {@code null}
     */
    void unRegister(Object listener);
}
