/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event;

import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class DefaultEventManager
implements EventManager,
ApplicationListener,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger((Class)DefaultEventManager.class);
    protected final ExecutorService executorService;
    protected final Map listenersByKey = new ConcurrentHashMap();
    protected final Map listenersByClass = new ConcurrentHashMap();
    protected final List globalListeners = new CopyOnWriteArrayList();
    protected ApplicationContext applicationContext;

    public DefaultEventManager() {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public DefaultEventManager(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void publishEvent(Event event) {
        if (event == null) {
            log.warn((Object)"Attempting to fire a null event. No action taken.");
            return;
        }
        this.applicationContext.publishEvent((ApplicationEvent)event);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof Event) {
            Event atlassianEvent = (Event)event;
            this.sendEventTo(atlassianEvent, this.globalListeners);
            this.sendEventTo(atlassianEvent, this.calculateListeners(((Object)((Object)atlassianEvent)).getClass()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring non Atlassian event: " + event.getClass().getName() + " - " + event.toString()));
        }
    }

    private Collection calculateListeners(Class eventClass) {
        HashSet listeners = new HashSet();
        this.calculateListeners(eventClass, listeners);
        return listeners;
    }

    private void calculateListeners(Class eventClass, Set listeners) {
        if (eventClass == null || eventClass.equals(Event.class) || eventClass.equals(Object.class)) {
            return;
        }
        Collection matchingListeners = (Collection)this.listenersByClass.get(eventClass);
        if (matchingListeners != null) {
            listeners.addAll(matchingListeners);
        }
        for (int i = 0; i < eventClass.getInterfaces().length; ++i) {
            Class<?> aClass = eventClass.getInterfaces()[i];
            this.calculateListeners(aClass, listeners);
        }
        this.calculateListeners(eventClass.getSuperclass(), listeners);
    }

    public synchronized void registerListener(String listenerKey, EventListener listener) {
        Class[] classes;
        Validate.notEmpty((String)listenerKey, (String)("Key for the listener must not be null: " + listenerKey));
        Validate.notNull((Object)listener, (String)("The listener must not be null: " + listener));
        if (this.listenersByKey.containsKey(listenerKey)) {
            this.unregisterListener(listenerKey);
        }
        if ((classes = listener.getHandledEventClasses()).length == 0) {
            this.globalListeners.add(listener);
        }
        for (int i = 0; i < classes.length; ++i) {
            this.addToListenerList(classes[i], listener);
        }
        this.listenersByKey.put(listenerKey, listener);
    }

    public synchronized void setDefaultListeners(Map listenerKeyPairs) {
        if (listenerKeyPairs != null) {
            Iterator iterator = listenerKeyPairs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String listenerKey = (String)entry.getKey();
                EventListener listener = (EventListener)entry.getValue();
                this.registerListener(listenerKey, listener);
            }
        }
    }

    public synchronized void unregisterListener(String listenerKey) {
        Validate.notEmpty((String)listenerKey, (String)("Key for the listener must not be null: " + listenerKey));
        EventListener listener = (EventListener)this.listenersByKey.get(listenerKey);
        Iterator it = this.listenersByClass.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            list.remove(listener);
        }
        this.listenersByKey.remove(listenerKey);
        this.globalListeners.remove(listener);
    }

    private void sendEventTo(Event event, Collection listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            EventListener eventListener = (EventListener)it.next();
            eventListener.handleEvent(event);
        }
    }

    private void addToListenerList(Class aClass, EventListener listener) {
        if (!this.listenersByClass.containsKey(aClass)) {
            this.listenersByClass.put(aClass, new CopyOnWriteArrayList());
        }
        ((List)this.listenersByClass.get(aClass)).add(listener);
    }
}

