/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event;

import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class DefaultEventManager
implements EventManager,
ApplicationListener,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger((Class)DefaultEventManager.class);
    private ApplicationContext applicationContext;
    private Map listenersByKey = new HashMap();
    private Map listenersByClass = new HashMap();
    private List globalListeners = new ArrayList();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void publishEvent(Event event) {
        if (event == null) {
            log.warn((Object)"Null event fired", (Throwable)new Exception("Null event fired"));
            return;
        }
        this.applicationContext.publishEvent((ApplicationEvent)event);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof Event) {
            Event confluenceEvent = (Event)event;
            this.sendEventTo(confluenceEvent, this.globalListeners);
            this.sendEventTo(confluenceEvent, this.calculateListeners(((Object)((Object)confluenceEvent)).getClass()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring non-Confluence event: " + event.getClass().getName() + " - " + event.toString()));
        }
    }

    private Collection calculateListeners(Class eventClass) {
        HashSet listeners = new HashSet();
        this.calculateListeners(eventClass, listeners);
        return listeners;
    }

    private void calculateListeners(Class eventClass, Set listeners) {
        if (eventClass == null || eventClass.equals(Event.class) || eventClass.equals(Object.class)) {
            return;
        }
        Collection matchingListeners = (Collection)this.listenersByClass.get(eventClass);
        if (matchingListeners != null) {
            listeners.addAll(matchingListeners);
        }
        for (int i = 0; i < eventClass.getInterfaces().length; ++i) {
            Class<?> aClass = eventClass.getInterfaces()[i];
            this.calculateListeners(aClass, listeners);
        }
        this.calculateListeners(eventClass.getSuperclass(), listeners);
    }

    public void registerListener(String listenerKey, EventListener listener) {
        Class[] classes;
        if (StringUtils.isEmpty((String)listenerKey)) {
            throw new IllegalArgumentException("Key for the listener must not be null: " + listenerKey);
        }
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be null: " + listener);
        }
        if (this.listenersByKey.containsKey(listenerKey)) {
            this.unregisterListener(listenerKey);
        }
        if ((classes = listener.getHandledEventClasses()).length == 0) {
            this.globalListeners.add(listener);
        }
        for (int i = 0; i < classes.length; ++i) {
            this.addToListenerList(classes[i], listener);
        }
        this.listenersByKey.put(listenerKey, listener);
    }

    public void unregisterListener(String listenerKey) {
        EventListener listener = (EventListener)this.listenersByKey.get(listenerKey);
        Iterator it = this.listenersByClass.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            list.remove(listener);
        }
        this.listenersByKey.remove(listenerKey);
        this.globalListeners.remove(listener);
    }

    private void sendEventTo(Event event, Collection listeners) {
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            EventListener eventListener = (EventListener)it.next();
            eventListener.handleEvent(event);
        }
    }

    private void addToListenerList(Class aClass, EventListener listener) {
        if (!this.listenersByClass.containsKey(aClass)) {
            this.listenersByClass.put(aClass, new ArrayList());
        }
        ((List)this.listenersByClass.get(aClass)).add(listener);
    }
}

