package com.atlassian.diagnostics.internal.platform.monitor.thread;

import com.atlassian.diagnostics.internal.jmx.ThreadMemoryAllocation;
import com.atlassian.diagnostics.internal.jmx.ThreadMemoryAllocationService;
import com.atlassian.diagnostics.internal.platform.poller.DiagnosticPoller;

import java.time.Instant;
import java.util.List;

public class ThreadPoller extends DiagnosticPoller<ThreadMonitorConfiguration> {

    private final ThreadMonitor threadMonitor;
    private final ThreadMemoryAllocationService threadMemoryAllocationService;

    public ThreadPoller(final ThreadMonitor threadMonitor,
                        final ThreadMonitorConfiguration monitorConfiguration,
                        final ThreadMemoryAllocationService threadMemoryAllocationService) {
        super(ThreadPoller.class.getName(), monitorConfiguration);
        this.threadMonitor = threadMonitor;
        this.threadMemoryAllocationService = threadMemoryAllocationService;
    }

    @Override
    protected void execute() {
        final List<ThreadMemoryAllocation> threadsWithHighMemoryUsage = threadMemoryAllocationService.getThreadMemoryAllocations(
                monitorConfiguration.maxThreadMemoryUsageInBytes(),
                monitorConfiguration.maxStackTraceDepth()
        );

        if (!threadsWithHighMemoryUsage.isEmpty()) {
            threadMonitor.raiseAlertForHighThreadMemoryUsage(Instant.now(), threadsWithHighMemoryUsage);
        }
    }
}
