package com.atlassian.diagnostics.internal.platform.monitor.event;

import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.event.spi.ListenerInvoker;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

/**
 * Wrapper around an {@link ListenerInvoker} that detects when slow event listeners and raises an event when the
 * listener is too slow.
 */
public class MonitoredListenerInvoker implements ListenerInvoker {

    private final ListenerInvoker delegate;
    private final EventSystemMonitor monitor;
    private final AlertTrigger trigger;

    public MonitoredListenerInvoker(EventSystemMonitor monitor, AlertTrigger trigger, ListenerInvoker delegate) {
        this.delegate = delegate;
        this.monitor = monitor;
        this.trigger = trigger;
    }

    @Override
    public Optional<String> getScope() {
        return delegate.getScope();
    }

    @Override
    public Set<Class<?>> getSupportedEventTypes() {
        return delegate.getSupportedEventTypes();
    }

    @Override
    public void invoke(Object event) {
        monitor.invokeMonitored(trigger, delegate, event);
    }

    @Override
    public boolean supportAsynchronousEvents() {
        return delegate.supportAsynchronousEvents();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MonitoredListenerInvoker that = (MonitoredListenerInvoker) o;
        return Objects.equals(delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(delegate);
    }

    @Override
    public String toString() {
        return delegate.toString() + " (monitored)";
    }

    @Override
    public int getOrder() {
        return delegate.getOrder();
    }
}
