package com.atlassian.diagnostics.internal.platform.monitor.cluster;

import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import javax.annotation.Nonnull;

public interface ClusterLockMonitorConfiguration extends MonitorConfiguration {

    /**
     * @return the threshold for waiting for a lock determined by (average wait time * queue size)
     */
    int lockWaitTimeThreshold();

    /**
     * @return the threshold for queue size
     */
    int queueSizeThreshold();

    /**
     * @return the schedule interval for the ClusterLockPoller
     */
    @Nonnull
    ScheduleInterval clusterLockPollerScheduleInterval();
}
