package com.atlassian.diagnostics.internal.platform.monitor;

import com.atlassian.diagnostics.DiagnosticsConfiguration;
import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import static java.util.concurrent.TimeUnit.SECONDS;

public class DefaultMonitorConfiguration implements MonitorConfiguration {

    private final DiagnosticsConfiguration diagnosticsConfiguration;

    public DefaultMonitorConfiguration(final DiagnosticsConfiguration diagnosticsConfiguration) {
        this.diagnosticsConfiguration = diagnosticsConfiguration;
    }

    @Override
    public boolean isEnabled() {
        return diagnosticsConfiguration.isEnabled();
    }

    protected ScheduleInterval defaultScheduleInterval() {
        return ScheduleInterval.of(5, SECONDS);
    }
}
