package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.ram;

import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.MemoryInformation;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class RamInformationProvider extends MemoryInformation {

    private final HardwareAbstractionLayer hardware;

    public RamInformationProvider() {
        this.hardware = new SystemInfo().getHardware();
    }

    long freeMemory() {
        return asMegaBytes(hardware.getMemory().getAvailable());
    }

    long totalMemory() {
        return asMegaBytes(hardware.getMemory().getTotal());
    }
}
