package com.atlassian.diagnostics.internal.platform.monitor.thread;

import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import javax.annotation.Nonnull;

public interface ThreadMonitorConfiguration extends MonitorConfiguration {

    /**
     * @return The threshold for thread memory usage
     */
    long maxThreadMemoryUsageInBytes();

    /**
     * @return Max stack trace depth for threads
     */
    int maxStackTraceDepth();

    /**
     * @return The interval for polling for thread memory
     */
    @Nonnull
    ScheduleInterval threadPollerScheduleInterval();
}
