package com.atlassian.diagnostics.internal.platform.monitor.db;

import java.util.Objects;

public class DatabasePoolDiagnostic {

    public static final DatabasePoolDiagnostic EMPTY = new DatabasePoolDiagnostic(0, 0, 0);

    private final int maxConnections;
    private final int activeConnections;
    private final int idleConnections;

    public DatabasePoolDiagnostic(final int idleConnections,
                                  final int activeConnections,
                                  final int maxConnections) {
        this.idleConnections = idleConnections;
        this.activeConnections = activeConnections;
        this.maxConnections = maxConnections;
    }

    public int getIdleConnections() {
        return idleConnections;
    }

    public int getActiveConnections() {
        return activeConnections;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public boolean isEmpty() {
        return this == EMPTY || maxConnections == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DatabasePoolDiagnostic that = (DatabasePoolDiagnostic) o;
        return maxConnections == that.maxConnections &&
                activeConnections == that.activeConnections &&
                idleConnections == that.idleConnections;
    }

    @Override
    public int hashCode() {
        return Objects.hash(maxConnections, activeConnections, idleConnections);
    }
}
