/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver;

import com.atlassian.diagnostics.internal.platform.monitor.db.pool.DatabasePoolDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver.JmxDatabasePoolAttributes;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.management.Attribute;
import javax.management.ObjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxDatabasePoolBean {
    private static final Logger logger = LoggerFactory.getLogger(JmxDatabasePoolBean.class);
    private final JmxDatabasePoolAttributes jmxAttributes;
    private final ObjectInstance objectInstance;

    JmxDatabasePoolBean(JmxDatabasePoolAttributes jmxAttributes, ObjectInstance objectInstance) {
        this.jmxAttributes = jmxAttributes;
        this.objectInstance = objectInstance;
    }

    public Optional<DatabasePoolDiagnostic> generateDatabasePoolMetrics() {
        logger.trace("Class Name: [{}]", (Object)this.objectInstance.getClassName());
        List<Attribute> resolvedBeanAttributes = this.jmxAttributes.getJmxAttributes(ManagementFactory.getPlatformMBeanServer(), this.objectInstance);
        try {
            if (!resolvedBeanAttributes.isEmpty()) {
                logger.trace("Found DB Pool values: [{}]", resolvedBeanAttributes);
                Integer idleConnections = this.getMBeanAttributeValue(resolvedBeanAttributes, 0);
                Integer activeConnections = this.getMBeanAttributeValue(resolvedBeanAttributes, 1);
                Integer maxConnections = this.getMBeanAttributeValue(resolvedBeanAttributes, 2);
                return Optional.of(new DatabasePoolDiagnostic(idleConnections, activeConnections, maxConnections));
            }
        }
        catch (Exception exception) {
            logger.error("Error querying for JMX attributes: [{}] on MBean: [{}]", new Object[]{this.jmxAttributes.poolUseAttributeNames, this.objectInstance, exception});
        }
        return Optional.empty();
    }

    private Integer getMBeanAttributeValue(List<Attribute> resolvedBeanAttributes, int index) {
        Integer value = (Integer)resolvedBeanAttributes.get(index).getValue();
        if (value == null) {
            throw new NullPointerException("beanAttribute value was null");
        }
        return value;
    }

    public Duration getPoolConnectionLeakTimeout() {
        try {
            Integer abandonedTimeoutValue;
            Object abandonedTimeoutAttribute = ManagementFactory.getPlatformMBeanServer().getAttribute(this.objectInstance.getObjectName(), this.jmxAttributes.abandonedTimeoutAttributeName);
            if (abandonedTimeoutAttribute instanceof Integer && (abandonedTimeoutValue = (Integer)abandonedTimeoutAttribute) != Integer.MAX_VALUE) {
                return Duration.ofSeconds(abandonedTimeoutValue.intValue());
            }
        }
        catch (Exception e) {
            logger.debug("Returning default DbPoolMetrics", (Throwable)e);
        }
        return Duration.ofMillis(0L);
    }
}

