/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.db.pool;

import com.atlassian.diagnostics.internal.platform.ConsecutiveAlertGate;
import com.atlassian.diagnostics.internal.platform.ConsecutiveAlertGateFactory;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseMonitor;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseMonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.DatabasePoolDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.DatabasePoolDiagnosticProvider;
import com.atlassian.diagnostics.internal.platform.poller.DiagnosticPoller;
import java.time.Clock;
import javax.annotation.Nonnull;

public class DatabasePoolPoller
extends DiagnosticPoller<DatabaseMonitorConfiguration> {
    private final DatabasePoolDiagnosticProvider databasePoolDiagnosticProvider;
    private final DatabaseMonitor databaseMonitor;
    private final Clock clock;
    private final ConsecutiveAlertGate alertGate;

    public DatabasePoolPoller(@Nonnull DatabaseMonitorConfiguration config, @Nonnull DatabaseMonitor databaseMonitor, @Nonnull DatabasePoolDiagnosticProvider databasePoolDiagnosticProvider, @Nonnull Clock clock, @Nonnull ConsecutiveAlertGateFactory alertGateFactory) {
        super(DatabasePoolPoller.class.getName(), config);
        this.databasePoolDiagnosticProvider = databasePoolDiagnosticProvider;
        this.databaseMonitor = databaseMonitor;
        this.clock = clock;
        this.alertGate = alertGateFactory.createAlertGate(config::poolUtilizationTimeWindow, clock);
    }

    @Override
    protected void execute() {
        this.databasePoolDiagnosticProvider.getDiagnostics().ifPresent(this::raiseAlertIfPoolUtilizationHasExceededThreshold);
    }

    private void raiseAlertIfPoolUtilizationHasExceededThreshold(DatabasePoolDiagnostic diagnostics) {
        if (this.alertGate.shouldRaiseAlert(() -> this.hasReachedDbPoolUtilisationThreshold(diagnostics))) {
            this.databaseMonitor.raiseAlertForHighPoolUtilization(this.clock.instant(), diagnostics);
        }
    }

    private boolean hasReachedDbPoolUtilisationThreshold(DatabasePoolDiagnostic diagnostic) {
        return (double)diagnostic.getMaxConnections() != 0.0 && (double)diagnostic.getActiveConnections() / (double)diagnostic.getMaxConnections() * 100.0 >= ((DatabaseMonitorConfiguration)this.monitorConfiguration).poolUtilizationPercentageLimit();
    }
}

