package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.directory;

import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.MemoryInformation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;

public class DirectorySpaceInformationProvider extends MemoryInformation {

    private final File directory;

    public DirectorySpaceInformationProvider(final File directory) {
        this.directory = directory;
    }

    long freeSpace() {
        try {
            FileStore fileStore = Files.getFileStore(directory.toPath());
            return asMegaBytes(fileStore.getUsableSpace());
        } catch (IOException ignore) {
            return -1;
        }
    }

    long totalSpace() {
        try {
            FileStore fileStore = Files.getFileStore(directory.toPath());
            return asMegaBytes(fileStore.getTotalSpace());
        } catch (IOException ignore) {
            return -1;
        }
    }
}
