package com.atlassian.diagnostics.internal.platform.monitor.http;


import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.diagnostics.internal.InitializingMonitor;
import com.google.common.collect.ImmutableMap;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.Map;

public class HttpRequestMonitor extends InitializingMonitor {

    private static final String KEY_PREFIX = "diagnostics.http.issue";
    private static final int SLOW_HTTP_REQUEST_ISSUE_ID = 3001;

    private final HttpMonitorConfiguration httpMonitorConfiguration;

    public HttpRequestMonitor(final HttpMonitorConfiguration httpMonitorConfiguration) {
        this.httpMonitorConfiguration = httpMonitorConfiguration;
    }

    @Override
    public void init(@Nonnull final MonitoringService monitoringService) {
        monitor = monitoringService.createMonitor("HTTP", "diagnostics.http.name", httpMonitorConfiguration);
        defineIssue(KEY_PREFIX, SLOW_HTTP_REQUEST_ISSUE_ID, Severity.INFO);
    }

    public void raiseAlertForSlowHttpRequest(@Nonnull final Instant timestamp, final HttpRequestDiagnostic diagnostic) {
        alert(SLOW_HTTP_REQUEST_ISSUE_ID, builder -> builder.timestamp(timestamp)
                .details(() -> slowHttpRequestAlertDetails(diagnostic))
                .build()
        );
    }

    private Map<Object, Object> slowHttpRequestAlertDetails(final HttpRequestDiagnostic diagnostic) {
        return ImmutableMap.builder()
                .put("requestPath", diagnostic.getRequestPath())
                .put("username", diagnostic.getUsername())
                .put("elapsedTimeInMillis", diagnostic.getRequestDuration().toMillis())
                .build();
    }
}

