package com.atlassian.diagnostics.internal.platform.monitor.db.pool;

import com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver.JmxDatabasePoolBean;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver.JmxDatabasePoolBeanResolver;

import java.time.Duration;
import java.util.Optional;

public class DefaultDatabasePoolDiagnosticProvider implements DatabasePoolDiagnosticProvider {

    private final JmxDatabasePoolBeanResolver jmxDatabasePoolBeanResolver;

    public DefaultDatabasePoolDiagnosticProvider(final JmxDatabasePoolBeanResolver jmxDatabasePoolBeanResolver) {
        this.jmxDatabasePoolBeanResolver = jmxDatabasePoolBeanResolver;
    }

    @Override
    public Optional<DatabasePoolDiagnostic> getDiagnostics() {
        return jmxDatabasePoolBeanResolver.getDatabaseConnectionPool()
                .flatMap(JmxDatabasePoolBean::generateDatabasePoolMetrics);
    }

    @Override
    public Duration getPoolConnectionLeakTimeout() {
        return jmxDatabasePoolBeanResolver.getDatabaseConnectionPool()
                .map(JmxDatabasePoolBean::getPoolConnectionLeakTimeout)
                .orElse(Duration.ZERO);
    }

}
