package com.atlassian.diagnostics.internal.platform.monitor.db;

import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import javax.annotation.Nonnull;
import java.time.Duration;

public interface DatabaseMonitorConfiguration extends MonitorConfiguration {

    /**
     * @return the connection pool abandonment timeout
     */
    @Nonnull
    Duration poolConnectionLeakTimeout();

    /**
     * @return the percentage limit for pool utilization
     */
    double poolUtilizationPercentageLimit();

    /**
     * @return the time duration to wait before raising a high pool utilization alert
     */
    @Nonnull
    Duration poolUtilizationTimeWindow();

    /**
     * @return the limit in millis-seconds for long running database queries
     */
    @Nonnull
    Duration longRunningOperationLimit();

    /**
     * @return configured setting for displaying the SQL query in the alert or an empty string
     */
    boolean includeSqlQueryInAlerts();

    @Nonnull
    ScheduleInterval databasePoolPollerScheduleInterval();
}
