/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.event;

import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.JsonMapper;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.diagnostics.detail.ThreadDumpProducer;
import com.atlassian.diagnostics.internal.InitializingMonitor;
import com.atlassian.diagnostics.internal.JacksonJsonMapper;
import com.atlassian.diagnostics.internal.concurrent.Gate;
import com.atlassian.diagnostics.internal.platform.event.EventDroppedDetails;
import com.atlassian.diagnostics.internal.platform.event.EventSystemMonitorConfig;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class EventSystemMonitor
implements InitializingMonitor {
    static final int ID_EVENT_DROPPED = 1001;
    static final int ID_SLOW_LISTENER = 2001;
    private final EventSystemMonitorConfig config;
    private final Object lock;
    private final Set<Thread> invokerThreads;
    private final ThreadDumpProducer threadDumpProducer;
    private final Gate threadDumpGate;
    private Clock clock;
    private volatile ComponentMonitor monitor;

    EventSystemMonitor(@Nonnull Clock clock, @Nonnull EventSystemMonitorConfig config, @Nonnull ThreadDumpProducer threadDumpProducer) {
        this.clock = Objects.requireNonNull(clock, "clock");
        this.config = Objects.requireNonNull(config, "config");
        this.threadDumpGate = new Gate(clock, config.getEventDroppedAlertThreadDumpCoolDown());
        this.threadDumpProducer = Objects.requireNonNull(threadDumpProducer, "threadDumpProducer");
        this.lock = new Object();
        this.invokerThreads = Sets.newConcurrentHashSet();
    }

    public EventSystemMonitor(@Nonnull EventSystemMonitorConfig config, @Nonnull ThreadDumpProducer threadDumpProducer) {
        this(Clock.systemDefaultZone(), config, threadDumpProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(MonitoringService monitoringService) {
        Object object = this.lock;
        synchronized (object) {
            ComponentMonitor mon = monitoringService.createMonitor("EVENT", "diagnostics.event.name");
            this.defineIssues(mon);
            this.monitor = mon;
        }
    }

    protected void defineIssues(ComponentMonitor monitor) {
        EventSystemMonitor.defineIssue(monitor, 1001, Severity.ERROR, EventDroppedDetails.class);
        EventSystemMonitor.defineIssue(monitor, 2001, Severity.WARNING, null);
    }

    void alertEventDropped(@Nonnull Instant timestamp, int queueLength, @Nonnull Class<?> eventClass) {
        Objects.requireNonNull(timestamp, "timestamp");
        this.alert(1001, builder -> builder.timestamp(timestamp).details(() -> {
            EventDroppedDetails.Builder detailsBuilder = new EventDroppedDetails.Builder(eventClass.getName(), queueLength);
            this.threadDumpGate.ifAccessible(() -> {
                detailsBuilder.threadDumps(this.threadDumpProducer.produce(this.getEventPoolThreads()));
                return null;
            });
            return detailsBuilder.build();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeMonitored(@Nonnull AlertTrigger trigger, @Nonnull ListenerInvoker delegate, @Nonnull Object event) {
        Instant start = this.clock.instant();
        this.invokerThreads.add(Thread.currentThread());
        try {
            delegate.invoke(event);
        }
        finally {
            this.invokerThreads.remove(Thread.currentThread());
            Duration duration = Duration.between(start, this.clock.instant());
            if (duration.compareTo(this.config.getSlowListenerAlertDuration(trigger)) >= 0) {
                this.alert(2001, builder -> builder.timestamp(start).trigger(trigger).details(() -> ImmutableMap.of((Object)"timeMillis", (Object)duration.toMillis(), (Object)"eventType", (Object)event.getClass().getName())));
            }
        }
    }

    private static void defineIssue(ComponentMonitor monitor, int id, Severity severity, Class<?> detailsClass) {
        String i18nPrefix = "diagnostics.event.issue." + StringUtils.leftPad((String)Integer.toString(id), (int)4, (char)'0') + ".";
        monitor.defineIssue(id).summaryI18nKey(i18nPrefix + "summary").descriptionI18nKey(i18nPrefix + "description").jsonMapper((JsonMapper)(detailsClass == null ? null : new JacksonJsonMapper(detailsClass))).severity(severity).build();
    }

    private void alert(int issueId, Consumer<AlertRequest.Builder> alertBuilder) {
        ComponentMonitor mon = this.monitor;
        if (mon != null && mon.isEnabled()) {
            mon.getIssue(issueId).ifPresent(issue -> {
                AlertRequest.Builder builder = new AlertRequest.Builder(issue);
                alertBuilder.accept(builder);
                mon.alert(builder.build());
            });
        }
    }

    private Set<Thread> getEventPoolThreads() {
        return this.config.getEventThreadGroup().map(threadGroup -> this.invokerThreads.stream().filter(thread -> thread.getThreadGroup().equals(threadGroup)).collect(Collectors.toSet())).orElse(this.invokerThreads);
    }
}

