package com.atlassian.diagnostics.internal.platform.event;

import com.atlassian.diagnostics.util.CallingBundleResolver;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.spi.ListenerHandler;

import java.util.Collections;
import java.util.List;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toList;

public class MonitoringListenerHandlersConfiguration implements ListenerHandlersConfiguration {

    private final CallingBundleResolver callingBundleResolver;
    private final ListenerHandlersConfiguration delegate;
    private final EventSystemMonitor monitor;
    private final String systemVersion;

    public MonitoringListenerHandlersConfiguration(CallingBundleResolver callingBundleResolver,
                                                   ListenerHandlersConfiguration delegate,
                                                   EventSystemMonitor monitor, String systemVersion) {
        this.callingBundleResolver = callingBundleResolver;
        this.delegate = delegate;
        this.monitor = monitor;
        this.systemVersion = systemVersion;
    }

    @Override
    public List<ListenerHandler> getListenerHandlers() {
        return delegate.getListenerHandlers().stream()
                .map(handler -> new MonitoringListenerHandler(callingBundleResolver, handler, monitor, systemVersion))
                .collect(collectingAndThen(toList(), Collections::unmodifiableList));
    }
}
