package com.atlassian.diagnostics.ipd.api.meters.config;

import com.atlassian.diagnostics.ipd.api.MeterKey;

/**
 * Interface for setting product-level meter configuration.
 * @since 5.0.0
 */
public interface ProductMeterConfigBuilder extends MeterConfigBuilder {
    /**
     * Set the object name factory for this meter. This is used to construct the JMX ObjectName for the meter.
     * @param objectNameFactory the object name factory
     * @return this builder
     */
    ProductMeterConfigBuilder setObjectNameConstructor(final MeterObjectNameConstructor objectNameFactory);

    /**
     * Builds the immutable meter configuration from this builder state and given meter key.
     * @param meterKey the meter key
     * @return the immutable meter configuration
     */
    MeterConfig build(final MeterKey meterKey);
}
