package com.atlassian.diagnostics.ipd.api.meters;

import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;

/**
 * Interface representing a value meter, which is a type of {@link IpdMeter}.
 * A value meter is used to record a single Long value.
 *
 * @since 3.0.0
 */
public interface ValueMeter extends IpdMeter {
    String TYPE_ID = "value";
    MeterFactory<ValueMeter> NOOP_FACTORY = new MeterFactory<>(Noop::new, "value", "value");

    void update(long value);

    @Override
    default String getTypeId() {
        return TYPE_ID;
    }

    class Noop extends NoopMeter implements ValueMeter {
        protected Noop(final MeterConfig meterConfig) {
            super(meterConfig);
        }

        @Override
        public void update(final long value) {
            metricUpdated();
        }
    }
}
